// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedure for backing up files.
//................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include "Check.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	HINSTANCE			hInst;
extern	LPTSTR				lpszNA;
extern	HWND				hMainWindow;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpIconPointer;
extern	HWND				hDialogModeLess;
extern	HWND				hDlgCurrent;
extern	BOOL				bProcessInProgress;
extern	BOOL				bCancelOperation;
extern	int					iNumberOfFiles;
extern	int					iStepIncrement;
extern	BOOL				bAviClipOK;
extern	HWND				hAviClip;
extern	LPCTSTR				lpszNullString;
extern	NUMBERFMT			nFormatInfo;
extern	HICON				hIcon2;
extern	BOOL				bSkipTheRest;
extern	SHFILEINFO			shfi1;
extern	LARGE_INTEGER		liHalfPercent;
extern	LARGE_INTEGER		liHalfPercentDup;
extern	HANDLE				hOutPutFile;
extern	HANDLE				hPublicKeyRing;
extern	HANDLE				hSecretKeyRing;
extern	BOOL				bUseNew;
extern	TCHAR				szPreviousDestinationDir[MAX_PATH];
extern	DWORD				dwKeyRingFilesActive;
extern	HFONT				hDlgFont;
extern	CONFIG				cfg;
extern	DWORD				dwStringSafeFlag;

#define	SIZE_BACKUP_BUFFER	(128 * 1024)

// Variables for the backup procedures.
//.....................................
LPBYTE			lpExtensionPtr;
int				iWhichAviClip;
int				iTotalFiles;
int				iFilesCopied;
TCHAR			szFileName[MAX_PATH];
TCHAR			szDestination[MAX_PATH];
LPBYTE			lpFileName;
LPBYTE			lpFileExtension;
LPTSTR			lpszDefaultIcon = "DefaultIcon";
HICON			hIcon;
LPTSTR			lpszExeFileExt = "*.exe";
LPTSTR			lpszIconFileExt = "*.ico";
LPTSTR			lpszDateTimeFormat = "modified on %s at %s";
LPTSTR			lpszSizeFormat = "File size: %s Bytes";
TCHAR			szFilesCopied[] = "%d out of %d Files Copied Successfully.";

// Backup one or more files.
//..........................
VOID BackupFiles(DWORD dwTypeOfCheck)
{
	ULARGE_INTEGER				uliFreeCallerBytes;
	ULARGE_INTEGER				uliTotalBytes;
	ULARGE_INTEGER				uliScratch1;
	ULARGE_INTEGER				uliScratch2;
	LARGE_INTEGER				liStats;
	OPENFILENAME				ofn;
	BY_HANDLE_FILE_INFORMATION	fi;
	TCHAR						szQuestion[256];
	TCHAR						szOutBuffer[256];
	TCHAR						szRoot[16];
	UINT						uiQuestion;
	UINT						uiDriveType;
	int							iResult;
	HANDLE						hInPutFile = 0;
	BOOL						bDiskError = FALSE;
	HRESULT						hr = ERROR_SUCCESS;
	DWORD						dwOldHelpTopic;
	DWORD						dwBytesRead;
	DWORD						dwBytesWritten;
	LPBYTE						lpBuffer = 0;
	LPBYTE						lpFileReturn;
	LPBYTE						lpTempFilePtr;
	LPBYTE						lpFileInsert;
	LPBYTE						lpDestinationInsert;
	int							iFileNameLength;
	BOOL						bResult;
	BOOL						bMoreThanOne;
	BROWSEINFO					bi;
    LPITEMIDLIST				lpidl;
    LPMALLOC					lpMalloc;
	WIN32_FIND_DATA				wfd;
	HANDLE						hSearch;

	bProcessInProgress = TRUE;
	lpFileReturn = 0;
	iFilesCopied = 0;

	dwOldHelpTopic = ChangeHelpTopic(IDH_BACKUPFILES);
	bAviClipOK = FALSE;

	if (dwTypeOfCheck == NO_CHECK)
	{
		// Close the two key ring files in case we want to copy them.
		//...........................................................
		bResult = CloseMyHandle((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing);
		if (!bResult)
		{
			goto BackupEnd;
		}
		dwKeyRingFilesActive--;
		hPublicKeyRing = 0;

		bResult = CloseMyHandle((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing);
		if (!bResult)
		{
			goto BackupEnd;
		}
		dwKeyRingFilesActive--;
		hSecretKeyRing = 0;
	}
	if (BPC())
	{
		goto BackupEnd;
	}
	// See if we have to display a pre or post check message.
	//.......................................................
	if (dwTypeOfCheck != NO_CHECK)
	{
		if (dwTypeOfCheck == BEFORE_CHECK)
		{
			uiQuestion = IDS_BACKUPBEFORE;
		}
		else if (dwTypeOfCheck == AFTER_CHECK)
		{
			uiQuestion = IDS_BACKUPAFTER;
		}
		else
		{
			goto BackupEnd;
		}
		// Ask if we want to backup the key ring files.
		//.............................................
		LoadString(hInst,uiQuestion,szQuestion,sizeof(szQuestion));
		StringCbPrintf(szOutBuffer,sizeof(szOutBuffer),TEXT("%s"),&szQuestion);
		iResult = MessageBoxProc(hMainWindow,IDS_QUESTION,(UINT)szOutBuffer,
								 MB_YESNO | MB_ICONQUESTION | MB_HELP,MB_ICONQUESTION,0);
		if (iResult == IDNO)
		{
			goto BackupEnd;
		}
	}
	// We only select files if we do not want to backup key rings.
	//............................................................
	if (dwTypeOfCheck == NO_CHECK)
	{
		// Initialize the OPENFILENAME structure.
		//.......................................
		InitializeOFN(&ofn,SAVE_SOURCE);	

		// Allocate the memory for the return file buffer. This is
		// the maximum sized buffer that the GetOpenFileName common
		// dialog box procedure can handle.
		//.........................................................
		lpFileReturn = AllocateMemory((64 * 1024) - 1);
		if (!lpFileReturn)
		{
			goto BackupEnd;
		}
		// Initialize with specific information for this procedure.
		//.........................................................
		ofn.lpstrFile = lpFileReturn;
		ofn.nMaxFile = ((64 * 1024) - 1);
		ofn.hwndOwner = hMainWindow;
		ofn.lpstrFilter = TEXT("Tscg Files [.rng;.rsakey;.tsc;.otp;.pad;.tsig;.jrl]\0*.rng;*.rsakey;*.tsc;*.otp;*.pad;*.tsig;*.jrl\0Compressed Files [.pkd;.lha;.zip;.arj;.cab]\0*.pkd;*.lha;*.zip;*.arj;*.cab\0Adobe PDF Files [.pdf]\0*.pdf\0Executable Files [.exe;.dll;.ocx]\0*.exe;*.dll;*.ocx\0Image Files [.bmp;.dib;.gif;.jpg;,ico;,cur]\0*.bmp;*.dib;*.gif;*.jpg;*.ico;*.cur\0Word Documents [.doc]\0*.doc\0Web Pages [.htm;.html;.mht]\0*.htm;*.html;*.mht\0Email Files [.eml]\0*.eml\0Rich Text Format [.rtf]\0*.rtf\0Text Files [.txt]\0*.txt\0Lotus 1-2-3 [.wk1;.wk3]\0*.wk1;*.wk3\0Microsoft Excel Worksheet [.xls;.xlw]\0*.xls;*.xlw\0Windows Write [.wri]\0*.wri\0WordPerfect 5.x [.doc]\0*.doc\0WordPerfect 6.x [.wpd;.doc]\0*.wpd;*.doc\0All Files [*.*]\0*.*\0");
		ofn.nFilterIndex = 1;
		ofn.lpstrTitle = TEXT("Select One or More Files to Backup");
		ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
					 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | 
					 OFN_ALLOWMULTISELECT | OFN_HIDEREADONLY);
		ofn.lpstrDefExt = NULL;
		ofn.lpfnHook = MyOFNHookProc;

		// Setup the icon to use in the caption bar.
		//..........................................
		lpIconPointer = lpszAppName;

		// Select the files to backup.
		//............................
		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto BackupEnd;
		}
		// Determine the number of files we have to backup.
		// Used to setup the progress bar.
		//.................................................
		lpTempFilePtr = (lpFileReturn + ofn.nFileOffset);
		iNumberOfFiles = 0;
		while(TRUE)
		{
			if (*lpTempFilePtr == 0)
			{
				break;
			}
			iFileNameLength = lstrlen(lpTempFilePtr);
			iNumberOfFiles++;

			// Point to the next file selected. Get past the
			// trailing null byte.
			//..............................................
			lpTempFilePtr += (int)(iFileNameLength + 1);
		}
	}
	// Setup the step increment for the progress bar.
	// Always equals one for this case.
	//...............................................
	iStepIncrement = 1;

	if (dwTypeOfCheck != NO_CHECK)
	{
		iNumberOfFiles = 2;
	}
	// Store the total number of files.
	//.................................
	iTotalFiles = iNumberOfFiles;

	if (dwTypeOfCheck == NO_CHECK)
	{
		// Setup the path for our selected files. If only 1 file
		// selected, we have the whole file spec.
		//......................................................
		ZeroMemory(&szFileName,sizeof(szFileName));
		StringCbCatEx((LPTSTR)&szFileName,sizeof(szFileName),lpFileReturn,NULL,NULL,
					   dwStringSafeFlag);

		// Save the path name.
		//....................
		if (iTotalFiles > 1)
		{
			SaveDirName((LPBYTE)&szFileName,SAVE_SOURCE,FALSE);
		}
		else
		{
			SaveDirName((LPBYTE)&szFileName,SAVE_SOURCE,TRUE);
		}
		// If we have more than one file we have to add a backslash.
		//.........................................................
		bMoreThanOne = FALSE;
		if (iNumberOfFiles > 1)
		{
			bMoreThanOne = TRUE;
			lpFileInsert = PathAddBackslash((LPTSTR)&szFileName);
		}
		lpTempFilePtr = (lpFileReturn + ofn.nFileOffset);

		// Determine the total size of all the selected files.
		//....................................................
		uliScratch1.QuadPart = 0;

		while(iNumberOfFiles > 0)
		{
			if (bMoreThanOne)
			{
				*lpFileInsert = 0;
				StringCbCatEx(szFileName,sizeof(szFileName),lpTempFilePtr,NULL,NULL,
							  dwStringSafeFlag);
				iFileNameLength = lstrlen(lpTempFilePtr);
				lpTempFilePtr += (int)(iFileNameLength + 1);
			}
			hSearch = FindFirstFile((LPCTSTR)&szFileName,&wfd);

			if (hSearch == INVALID_HANDLE_VALUE)
			{
				ErrorProcedure((LPTSTR)&szFileName,IDS_FINDFIRSTFILE,MB_OK);
				goto BackupEnd;
			}
			FindClose(hSearch);
			uliScratch2.LowPart = wfd.nFileSizeLow;
			uliScratch2.HighPart = wfd.nFileSizeHigh;
			uliScratch1.QuadPart += uliScratch2.QuadPart;

			iNumberOfFiles--;
		}
	}
	else
	{
		uliScratch1.QuadPart = 0;

		// Determine only the size of the two key ring files.
		//...................................................
		uliScratch2.QuadPart = GetMyFileSize((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing);
		if (uliScratch2.QuadPart == -1)
		{
			goto BackupEnd;
		}
		uliScratch1.QuadPart = uliScratch2.QuadPart;

		uliScratch2.QuadPart = GetMyFileSize((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing);
		if (uliScratch2.QuadPart == -1)
		{
			goto BackupEnd;
		}
		uliScratch1.QuadPart += uliScratch2.QuadPart;
	}
	iNumberOfFiles = iTotalFiles;

	if (dwTypeOfCheck == NO_CHECK)
	{
		lpTempFilePtr = (lpFileReturn + ofn.nFileOffset);
	}
	// Determine what is a half percent for updating the progress bar.
	//................................................................
	if (uliScratch1.QuadPart < 40000)
	{
		__asm
		{
			xor		edx,edx
			mov		eax,uliScratch1.LowPart
			mov		ecx,200
			div		ecx
			cmp		eax,edx
			jae		L1
			inc		eax
		L1:	mov		liHalfPercent.HighPart,0
			mov		liHalfPercent.LowPart,eax
		}
	}
	else
	{
		liHalfPercent.QuadPart = (uliScratch1.QuadPart / 200);
	
		if (liHalfPercent.QuadPart == 0)
		{
			liHalfPercent.QuadPart = 1;
		}
	}
	liHalfPercentDup.QuadPart = liHalfPercent.QuadPart;

	EmptyTheMessageQue();

	// Browse for a directory to copy the files into.
	//...............................................
	while(TRUE)
	{
		SetCurrentDirectory((LPCTSTR)&szPreviousDestinationDir);
		ZeroMemory(&szDestination,sizeof(szDestination));

		if (SUCCEEDED(SHGetMalloc(&lpMalloc))) 
		{
			ZeroMemory(&bi,sizeof(bi));
			bi.hwndOwner = hMainWindow;
			bi.pszDisplayName = 0;

			if (dwTypeOfCheck == NO_CHECK)
			{
				bi.lpszTitle = TEXT("Copy Selected Files To?");
			}
			else
			{
				bi.lpszTitle = TEXT("Copy Loaded Key Ring Files To?");
			}
			bi.pidlRoot = 0;
			bi.ulFlags = BIF_RETURNONLYFSDIRS;

			// If we can use the new style of the dialog box, do it.
			//......................................................
			if (bUseNew)
			{
				hr = CoInitialize(NULL);
				if (SUCCEEDED(hr))
				{
					bi.ulFlags |= BIF_NEWDIALOGSTYLE;
				}
			}
			bi.lpfn = BrowseCallbackProc;

			lpidl = SHBrowseForFolder(&bi);

			if (bUseNew && SUCCEEDED(hr))
			{
				CoUninitialize();
			}
			if (lpidl) 
			{
				bResult = SHGetPathFromIDList(lpidl,szDestination);
				lpMalloc->lpVtbl->Free(lpMalloc,lpidl);
				lpMalloc->lpVtbl->Release(lpMalloc);
			}
			else
			{
				// We cancelled out.
				//..................
				goto BackupEnd;
			}
			// Save the dir name.
			//...................
			SaveDirName((LPBYTE)&szDestination,SAVE_DESTINATION,FALSE);

			if (dwTypeOfCheck == NO_CHECK)
			{
				// See if the source and destination is the same.
				//...............................................
				iResult = CompareString(LOCALE_USER_DEFAULT,0,szFileName,
									   (ofn.nFileOffset - 1),szDestination,-1);
				if (iResult == CSTR_EQUAL)
				{
					MessageBoxProc(hMainWindow,IDS_INPUT_ERROR,IDS_NOCOPYTOSAME,
								   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
					continue;
				}
			}
			else
			{
				CopyMemory(&szFileName,&cfg.szPublicKeyRing,MAX_PATH);
				PathRemoveFileSpec((LPTSTR)&szFileName);

				// See if the source and destination is the same.
				//...............................................
				iResult = CompareString(LOCALE_USER_DEFAULT,0,szFileName,
									   (ofn.nFileOffset - 1),szDestination,-1);
				if (iResult == CSTR_EQUAL)
				{
					MessageBoxProc(hMainWindow,IDS_INPUT_ERROR,IDS_NOCOPYTOSAME,
								   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
					continue;
				}

				CopyMemory(&szFileName,&cfg.szSecretKeyRing,MAX_PATH);
				PathRemoveFileSpec((LPTSTR)&szFileName);

				// See if the source and destination is the same.
				//...............................................
				iResult = CompareString(LOCALE_USER_DEFAULT,0,szFileName,
									   (ofn.nFileOffset - 1),szDestination,-1);
				if (iResult == CSTR_EQUAL)
				{
					MessageBoxProc(hMainWindow,IDS_INPUT_ERROR,IDS_NOCOPYTOSAME,
								   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
					continue;
				}
			}
			// See if we have any free disk space. cd rom drives that
			// are not writable will report zero.
			//.......................................................
			ZeroMemory(&szRoot,sizeof(szRoot));
			CopyMemory(&szRoot,&szDestination,3);
			bResult = GetDiskFreeSpaceEx((LPCTSTR)&szRoot,
										(PULARGE_INTEGER)&uliFreeCallerBytes.QuadPart,
										(PULARGE_INTEGER)&uliTotalBytes.QuadPart,NULL);
			if (!bResult)
			{
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
				goto BackupEnd;
			}
			if (uliFreeCallerBytes.QuadPart == 0)
			{
				SetLastError(IDS_NOSPACE);
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
				continue;
			}
			// Make sure we do not backup to a ram disk.
			//..........................................
			uiDriveType = GetDriveType((LPCTSTR)&szRoot);
			if (uiDriveType == DRIVE_RAMDISK)
			{
				SetLastError(IDS_RAMDRIVE);
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETDRIVETYPE,MB_OK);
				continue;
			}
			// If we go this far with no error, we have a valid
			// destination.
			//.................................................
			break;
		}
		else
		{
			MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_SELECTDIR,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
			goto BackupEnd;
		}
	}
	// Setup the destination file spec.
	//.................................
	lpDestinationInsert = PathAddBackslash((LPTSTR)&szDestination);

	// Determine which avi clip to use: file copy, file disk,
	// or file cd rom.
	//.......................................................
	iWhichAviClip = FILE_COPY;
	if (uiDriveType == DRIVE_REMOVABLE && (*szDestination == 0x41 ||
		*szDestination == 0x61 || *szDestination == 0x42 ||
		*szDestination == 0x62))
	{
		iWhichAviClip = FILE_DISK;
	}
	else if (uiDriveType == DRIVE_CDROM)
	{
		iWhichAviClip = FILE_CDROM;
	}
	// Setup our modeless dialog box for backing up the files.
	//........................................................
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("BACKUPFILES"),hMainWindow,
							      (DLGPROC)BackupFilesProc);

	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto BackupEnd;
	}
	// Start the avi clip.
	//....................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Play(hAviClip,0,-1,-1);
	}
	// Make sure bSkipTheRest is FALSE.
	//.................................
	bSkipTheRest = FALSE;

	// Allocate memory for the buffer.
	//................................
	lpBuffer = AllocateMemory(SIZE_BACKUP_BUFFER);
	if (!lpBuffer)
	{
		goto BackupEnd;
	}
	// If we are only copying the key ring files call a separate procedure.
	//.....................................................................
	if (dwTypeOfCheck != NO_CHECK)
	{
		bDiskError = BackupKeyRings(lpBuffer);
		goto FinalStats;
	}
	// Go into a loop and copy all the files.
	//.......................................
	while(iNumberOfFiles > 0)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			break;
		}
		// Append the file name to the destination file spec.
		//...................................................
		*lpDestinationInsert = 0;
		StringCbCatEx(szDestination,sizeof(szDestination),lpTempFilePtr,NULL,NULL,
					  dwStringSafeFlag);

		// If we have more than one file we have to append the
		// file name to the path.
		//....................................................
		if (bMoreThanOne)
		{
			*lpFileInsert = 0;
			StringCbCatEx(szFileName,sizeof(szFileName),lpTempFilePtr,NULL,NULL,
						  dwStringSafeFlag);
			iFileNameLength = lstrlen(lpTempFilePtr);
		}
		// Get a pointer to the file name and file extension if
		// we need it later.
		//.....................................................
		lpFileExtension = PathFindExtension((LPCTSTR)szFileName);
		lpFileName = PathFindFileName((LPCTSTR)szFileName);

		// Destroy the icon if we used it.
		//................................
		if (hIcon)
		{
			DestroyIcon(hIcon);
			hIcon = 0;
		}
		// Let find the icon for the file.
		//................................
		hIcon = FindMyIcon((LPBYTE)&szFileName,lpFileExtension);

		// If we did not find one, use the default.
		//.........................................
		if (!hIcon)
		{
			hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
		}
		// If we do not skip checking the rest, see if the file exists
		// and ask if we want to overwrite it if it does.
		//.............................................................
		if (!bSkipTheRest)
		{
			hSearch = FindFirstFile((LPCTSTR)&szDestination,&wfd);
		
			if (hSearch != INVALID_HANDLE_VALUE)
			{
				FindClose(hSearch);

				FlashMyIcon(FALSE);

				// Ask if we want to overwrite the file.
				//......................................
				iResult = DialogBox(hInst,TEXT("ASKOVERWRITE"),hDialogModeLess,
								   (DLGPROC)AskOverwriteProc);

				EmptyTheMessageQue();

				// See if we had a system error in creating the dialog box.
				//.........................................................
				if (iResult == -1)
				{
					ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
					goto BackupEnd;
				}
				// Quit if we canceled.
				//.....................
				if (iResult == IDCANCEL)
				{
					break;
				}
				// If we said no.
				//...............
				if (iResult == IDC_MYNO)
				{
					// Point to the next file selected. Get past the
					// trailing null byte.
					//..............................................
					lpTempFilePtr += (int)(iFileNameLength + 1);	

					iNumberOfFiles--;
					continue;
				}
			}
		}

		EmptyTheMessageQue();

		// Set bDiskError to TRUE.
		//........................
		bDiskError = TRUE;

		// Open the input file.
		//.....................
		hInPutFile = CreateMyFile((LPTSTR)&szFileName,GENERIC_READ,FILE_SHARE_READ,
								   NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hInPutFile)
		{
			goto FinalStats;
		}
		// Get the attribs and file times to put on the copied files.
		//...........................................................
		bResult = GetFileInformationByHandle(hInPutFile,&fi);
		if (!bResult)
		{
			ErrorProcedure((LPTSTR)&szFileName,IDS_GETFILEINFO,MB_OK);
			goto FinalStats;
		}
		// Create the output file.
		//........................
		hOutPutFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,
								    0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hOutPutFile)
		{
			goto FinalStats;
		}
		liStats.QuadPart = 0;

		// Display the icon and file name.
		//................................
		if (hIcon2)
		{
			DestroyIcon(hIcon2);
		}
		hIcon2 = hIcon;
		hIcon = 0;

		SendMessage(GetDlgItem(hDialogModeLess,IDC_ICON1),STM_SETICON,(WPARAM)hIcon2,0);
		SetDlgItemTextFmt(hDialogModeLess,IDC_BACKUPFILENAME,
					     (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szFileName));

		// Go into a loop and copy the file.
		//..................................
		while(TRUE)
		{
			EmptyTheMessageQue();
			if (bCancelOperation == TRUE)
			{
				goto FinalStats;
			}
			bResult = ReadMyFile((LPTSTR)&szFileName,hInPutFile,lpBuffer,SIZE_BACKUP_BUFFER,
								  &dwBytesRead,NULL);
			if (!bResult)
			{
				goto FinalStats;
			}
			// Check for end of file.
			//.......................
			if (dwBytesRead == 0)
			{
				break;
			}
			bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,lpBuffer,dwBytesRead,
								   &dwBytesWritten,NULL);
			if (!bResult)
			{
				goto FinalStats;
			}
			// Update the status bar to reflect this file.
			//............................................
			liStats.QuadPart += dwBytesRead;
			while(liStats.QuadPart >= liHalfPercentDup.QuadPart)
			{
				SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);
				liStats.QuadPart -= liHalfPercentDup.QuadPart;
			}
		}
		// Close the files and clean up.
		//..............................
		bResult = CloseMyHandle((LPTSTR)&szFileName,hInPutFile);
		if (!bResult)
		{
			goto FinalStats;
		}
		hInPutFile = 0;

		bResult = SetFileTime(hOutPutFile,&fi.ftCreationTime,&fi.ftLastAccessTime,
							  &fi.ftLastWriteTime);
		if (!bResult)
		{
			ErrorProcedure((LPTSTR)&szDestination,IDS_SETFILETIME,MB_OK);
		}
		bResult = CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
		if (!bResult)
		{
			goto FinalStats;
		}
		hOutPutFile = 0;
		bDiskError = FALSE;

		bResult = SetFileAttributes((LPCTSTR)&szDestination,fi.dwFileAttributes);
		if (!bResult)
		{
			ErrorProcedure((LPTSTR)&szDestination,IDS_SETFILEATTR,MB_OK);
		}
		// Update the files copied.
		//.........................
		iFilesCopied++;
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFilesCopied,
					    iFilesCopied,iTotalFiles);
		SetDlgItemText(hDialogModeLess,IDC_STATEMENT1,(LPCTSTR)&szOutBuffer);

		// Point to the next file selected. Get past the
		// trailing null byte.
		//..............................................
		lpTempFilePtr += (int)(iFileNameLength + 1);

		iNumberOfFiles--;
	}

  FinalStats:

	// Print the final stats.
	//.......................
	StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFilesCopied,
				    iFilesCopied,iTotalFiles);
	SetDlgItemText(hDialogModeLess,IDC_STATEMENT1,(LPCTSTR)&szOutBuffer);

	// If we copied all the files make sure the progress bar is set to 100%.
	//......................................................................
	if (iFilesCopied == iTotalFiles)
	{
		SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_SETPOS,(WPARAM)200,0);
	}
	// Make sure bCancelOperation is set to FALSE.
	//............................................
	bCancelOperation = FALSE;

	// Stop the avi clip.
	//...................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Stop(hAviClip);
	}
	// Change the cancel button to ok.
	//................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	FlashMyIcon(TRUE);

	// Wait until we close the dialog box to exit.
	//............................................
	while(TRUE)
	{
		CheckForMessages();
		if (bCancelOperation == TRUE)
		{
			break;
		}
	}

	BackupEnd:

	FlashMyIcon(FALSE);

	if (hIcon)
	{
		DestroyIcon(hIcon);
		hIcon = 0;
	}
	if (hIcon2)
	{
		DestroyIcon(hIcon2);
		hIcon2 = 0;
	}
	if (bAviClipOK)
	{
		Animate_Close(hAviClip);
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (lpFileReturn)
	{
		DeallocateMemory(lpFileReturn);
	}
	if (lpBuffer)
	{
		ZeroMemory(lpBuffer,SIZE_BACKUP_BUFFER);
		DeallocateMemory(lpBuffer);
	}
	if (hInPutFile)
	{
		CloseMyHandle((LPTSTR)&szFileName,hInPutFile);
	}
	if (hOutPutFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
		hOutPutFile = 0;
		if (bDiskError)
		{
			DeleteMyFile((LPTSTR)&szDestination);
		}
	}
	if (!hPublicKeyRing)
	{
		hPublicKeyRing = CreateMyFile(cfg.szPublicKeyRing,GENERIC_READ | GENERIC_WRITE,
								      0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (hPublicKeyRing)
		{
			dwKeyRingFilesActive++;
		}
	}
	if (!hSecretKeyRing)
	{
		hSecretKeyRing = CreateMyFile(cfg.szSecretKeyRing,GENERIC_READ | GENERIC_WRITE,
									  0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (hSecretKeyRing)
		{
			dwKeyRingFilesActive++;
		}
	}
	if (dwKeyRingFilesActive != 6)
	{
		CloseAllKeyRingFiles();
	}
	
	bCancelOperation = FALSE;
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// Browse callback function for selecting a directory.
//....................................................
int CALLBACK BrowseCallbackProc(HWND hWnd, UINT uMsg, LPARAM lParam, 
								LPARAM lpData)
{
	TCHAR	szDir[MAX_PATH];

    switch(uMsg) 
	{
		case BFFM_INITIALIZED:
		{
			if (GetCurrentDirectory(sizeof(szDir),szDir))
			{
				// WParam is TRUE since you are passing a path.
                // It would be FALSE if you were passing a pidl.
				//..............................................
                SendMessage(hWnd,BFFM_SETSELECTION,TRUE,(LPARAM)szDir);

				// Center the browse for folder window.
				//.....................................
				CenterWindow(hWnd,GetWindow(hWnd,GW_OWNER));
             }
             break;
		}
        default:
			break;
	}
    return 0;
}

// CALLBACK procedure for the backup files dialog box.
//....................................................
LRESULT CALLBACK BackupFilesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			SetBoldFont(hDlg,IDC_STATEMENT1,0);

			// Open the avi clip and display its first frame
			// in the animation control.
			//..............................................
			hAviClip = GetDlgItem(hDlg,IDC_ANIMATE);
			bAviClipOK = Animate_Open(hAviClip,(LPSTR)iWhichAviClip);

			// Setup the range and step increment for the progress bar.
			//.........................................................
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETRANGE32,0,(LPARAM)200);
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETSTEP,(WPARAM)iStepIncrement,0);

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			if(hDlgFont)
			{
				DeleteObject(hDlgFont);
				hDlgFont = 0;
			}
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for the ask if we want to overwrite dialog box.
//...................................................................
LRESULT CALLBACK AskOverwriteProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			LARGE_INTEGER		li;
			WIN32_FIND_DATA		FindData;
			TCHAR				szInBuffer[332];
			TCHAR				szFormatedNumber[64];
			HANDLE				hSearchHandle;
			FILETIME			ftLocalTime;
			SYSTEMTIME			stLocalTime;
			TCHAR				szLocalDate[128];
			TCHAR				szLocalTime[64];

			// Clear a few variables.
			//.......................
			ZeroMemory(&szFormatedNumber,sizeof(szFormatedNumber));
			ZeroMemory(&szLocalDate,sizeof(szLocalDate));
			ZeroMemory(&szLocalTime,sizeof(szLocalTime));
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Setup the dialog box.
			//......................
			SetDlgItemTextFmt(hDlg,IDC_CONTAINS,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szFileName));

			if (hIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon,0);
				SendMessage(GetDlgItem(hDlg,IDC_ICON2),STM_SETICON,(WPARAM)hIcon,0);
			}
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Setup the file information for each file.
			// Do the destination file first.
			//..........................................
			hSearchHandle = FindFirstFile((LPCTSTR)&szDestination,&FindData);
			FindClose(hSearchHandle);
			li.LowPart = FindData.nFileSizeLow;
			li.HighPart = FindData.nFileSizeHigh;
			_i64toa(li.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				            &nFormatInfo,(LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszSizeFormat,szFormatedNumber);
			SetDlgItemText(hDlg,IDC_SIZE1,(LPCTSTR)szInBuffer);
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Now do the time and date.
			//..........................
			FileTimeToLocalFileTime((LPFILETIME)&FindData.ftLastWriteTime,
							        (LPFILETIME)&ftLocalTime);
			FileTimeToSystemTime((LPFILETIME)&ftLocalTime,(LPSYSTEMTIME)&stLocalTime);

			// Format the date.
			//.................
			GetDateFormat(LOCALE_USER_DEFAULT,DATE_LONGDATE,&stLocalTime,
				          NULL,(LPTSTR)&szLocalDate,sizeof(szLocalDate));

			// Format the time.
			//.................
			GetTimeFormat(LOCALE_USER_DEFAULT,TIME_FORCE24HOURFORMAT,
						  &stLocalTime,NULL,(LPTSTR)&szLocalTime,sizeof(szLocalTime));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszDateTimeFormat,&szLocalDate,
						   &szLocalTime);
			SetDlgItemText(hDlg,IDC_DATETIME1,(LPCTSTR)szInBuffer);

			// Clear a few variables.
			//.......................
			ZeroMemory(&szFormatedNumber,sizeof(szFormatedNumber));
			ZeroMemory(&szLocalDate,sizeof(szLocalDate));
			ZeroMemory(&szLocalTime,sizeof(szLocalTime));
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Setup the information for the source file.
			//...........................................
			hSearchHandle = FindFirstFile((LPCTSTR)&szFileName,&FindData);
			FindClose(hSearchHandle);
			li.LowPart = FindData.nFileSizeLow;
			li.HighPart = FindData.nFileSizeHigh;
			_i64toa(li.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				            &nFormatInfo,(LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszSizeFormat,szFormatedNumber);
			SetDlgItemText(hDlg,IDC_SIZE2,(LPCTSTR)szInBuffer);
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Now do the time and date.
			//..........................
			FileTimeToLocalFileTime((LPFILETIME)&FindData.ftLastWriteTime,
									(LPFILETIME)&ftLocalTime);
			FileTimeToSystemTime((LPFILETIME)&ftLocalTime,(LPSYSTEMTIME)&stLocalTime);
			// Format the date.
			//.................
			GetDateFormat(LOCALE_USER_DEFAULT,DATE_LONGDATE,&stLocalTime,
				          NULL,(LPTSTR)&szLocalDate,sizeof(szLocalDate));

			// Format the time.
			//.................
			GetTimeFormat(LOCALE_USER_DEFAULT,TIME_FORCE24HOURFORMAT,
						  &stLocalTime,NULL,(LPTSTR)&szLocalTime,sizeof(szLocalTime));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszDateTimeFormat,&szLocalDate,
						   &szLocalTime);
			SetDlgItemText(hDlg,IDC_DATETIME2,(LPCTSTR)szInBuffer);

			// If we only have one file, disable the Yes to All button.
			//.........................................................
			if (iNumberOfFiles == 1)
			{
				EnableWindow(GetDlgItem(hDlg,IDC_YESTOALL),FALSE);
			}
			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{

				case IDC_MYYES:
				{
					EndDialog(hDlg,IDC_MYYES);
				}
				break;

				case IDC_YESTOALL:
				{
					bSkipTheRest = TRUE;
					EndDialog(hDlg,IDC_YESTOALL);
				}
				break;

				case IDC_MYNO:
				{
					EndDialog(hDlg,IDC_MYNO);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	
		default:
			return(FALSE);
	}
	return(TRUE);
}

// Retrieves an icon associated with a file.
// If it can't find one return null.
//..........................................
HICON FindMyIcon(LPBYTE lpFileSpec, LPBYTE lpFileExt)
{
	TCHAR				szOutBuffer[300];
	TCHAR				szInBuffer[300];
	DWORD				dwResult;
	DWORD				dwTypeKey;
	DWORD				dwSizeBuffer;
	HICON				hMyIcon;
	int					iIconLocation;
	UINT				uiIcons;
	BOOL				bResult;

	hMyIcon = 0;

	// First let's see if we have an exe file extension.
	// If we do, we get the first icon in the exe file.
	//..................................................
	bResult = PathMatchSpec((LPCTSTR)lpFileSpec,(LPCTSTR)lpszExeFileExt);
	if (bResult)
	{
		uiIcons = ExtractIconEx((LPCTSTR)lpFileSpec,0,&hMyIcon,NULL,1);
		if (uiIcons == 0)
		{
			hMyIcon = 0;
		}
		goto FindIconEnd;
	}
    // Lets check for an icon file.
	//.............................
	bResult = PathMatchSpec((LPCTSTR)lpFileSpec,(LPCTSTR)lpszIconFileExt);
	if (bResult)
	{
		uiIcons = ExtractIconEx((LPCTSTR)lpFileSpec,0,&hMyIcon,NULL,1);
		if (uiIcons == 0)
		{
			hMyIcon = 0;
		}
		goto FindIconEnd;
	}	
	// Let's setup the file icon if we can find one.
	// If not, use the frown face icon.
	//..............................................
	ZeroMemory(&szOutBuffer,sizeof(szOutBuffer));
	ZeroMemory(&szInBuffer,sizeof(szInBuffer));
	dwTypeKey = REG_SZ;
	dwSizeBuffer = sizeof(szOutBuffer);
	hMyIcon = 0;
	dwResult = SHGetValue(HKEY_CLASSES_ROOT,lpFileExt,lpszNullString,
						  &dwTypeKey,&szOutBuffer,&dwSizeBuffer);
	if (dwResult == ERROR_SUCCESS)
	{
		// Add a back slash to the entry, and then append
		// DefaultIcon to it.
		//...............................................
		dwSizeBuffer = sizeof(szInBuffer);
		PathAddBackslash((LPTSTR)&szOutBuffer);
		StringCbCatEx((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)lpszDefaultIcon,
					   NULL,NULL,dwStringSafeFlag);
		dwResult = SHGetValue(HKEY_CLASSES_ROOT,(LPCTSTR)&szOutBuffer,
							  lpszNullString,&dwTypeKey,&szInBuffer,&dwSizeBuffer);
		// Break up the returned string so we can get at the icon.
		//........................................................
		if (dwResult == ERROR_SUCCESS)
		{
			iIconLocation = PathParseIconLocation((LPSTR)&szInBuffer);
			uiIcons = ExtractIconEx((LPCTSTR)&szInBuffer,iIconLocation,&hMyIcon,NULL,1);
			if (uiIcons == 0)
			{
				hMyIcon = 0;
			}
			goto FindIconEnd;
		}
	}
	FindIconEnd:
	return(hMyIcon);
}

// Backup the loaded set of key rings.
//....................................
BOOL BackupKeyRings(LPBYTE lpBuffer)
{
	LARGE_INTEGER				liStats;
	BOOL						bDiskError = FALSE;
	BOOL						bResult;
	BY_HANDLE_FILE_INFORMATION	fi;
	LPBYTE						lpDestinationInsert;
	DWORD						dwBytesRead;
	DWORD						dwBytesWritten;
	TCHAR						szOutBuffer[256];
	WIN32_FIND_DATA				wfd;
	HANDLE						hSearch;
	int							iResult;

	// Rewind the key ring files.
	//...........................
	bResult = RewindAllKeyRingFiles();
	if (!bResult)
	{
		goto BackupRingsEnd;
	}

	lpDestinationInsert = PathAddBackslash((LPTSTR)&szDestination);

	// Do the public key first.
	//.........................
	lpFileExtension = PathFindExtension((LPCTSTR)&cfg.szPublicKeyRing);
	lpFileName = PathFindFileName((LPCTSTR)&cfg.szPublicKeyRing);

	// Setup the destination spec. for the public key ring.
	//.....................................................
	*lpDestinationInsert = 0;
	StringCbCatEx(szDestination,sizeof(szDestination),lpFileName,NULL,NULL,
				  dwStringSafeFlag);

	// Destroy the icon if we used it.
	//................................
	if (hIcon)
	{
		DestroyIcon(hIcon);
		hIcon = 0;
	}
	// Let find the icon for the file.
	//................................
	hIcon = FindMyIcon((LPBYTE)&cfg.szPublicKeyRing,lpFileExtension);

	// If we did not find one, use the default.
	//.........................................
	if (!hIcon)
	{
		hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
	}
	// See if the file exists in the destination.
	//...........................................
	hSearch = FindFirstFile((LPCTSTR)&szDestination,&wfd);
		
	if (hSearch != INVALID_HANDLE_VALUE)
	{
		FindClose(hSearch);

		FlashMyIcon(FALSE);

		CopyMemory(&szFileName,&cfg.szPublicKeyRing,MAX_PATH);

		// Ask if we want to overwrite the file.
		//......................................
		iResult = DialogBox(hInst,TEXT("ASKOVERWRITE"),hDialogModeLess,
						   (DLGPROC)AskOverwriteProc);

		EmptyTheMessageQue();

		// See if we had a system error in creating the dialog box.
		//.........................................................
		if (iResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto BackupRingsEnd;
		}
		// Quit if we canceled.
		//.....................
		if (iResult == IDCANCEL)
		{
			goto BackupRingsEnd;
		}
		// If we said no.
		//...............
		if (iResult == IDC_MYNO)
		{
			iNumberOfFiles--;
			goto SecretKeyRing;
		}
	}

	EmptyTheMessageQue();

	// Set bDiskError to TRUE.
	//........................
	bDiskError = TRUE;

	// Create the output file.
	//........................
	hOutPutFile =  CreateMyFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,
							     0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hOutPutFile)
	{
		goto BackupRingsEnd;
	}
	liStats.QuadPart = 0;

	// Display the icon and file name.
	//................................
	if (hIcon2)
	{
		DestroyIcon(hIcon2);
	}
	hIcon2 = hIcon;
	hIcon = 0;

	SendMessage(GetDlgItem(hDialogModeLess,IDC_ICON1),STM_SETICON,(WPARAM)hIcon2,0);
	SetDlgItemTextFmt(hDialogModeLess,IDC_BACKUPFILENAME,
					 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&cfg.szPublicKeyRing));

	EmptyTheMessageQue();

	// Get the attribs and file times to put on the copied files.
	//...........................................................
	bResult = GetFileInformationByHandle(hPublicKeyRing,&fi);
	if (!bResult)
	{
		ErrorProcedure((LPTSTR)&cfg.szPublicKeyRing,IDS_GETFILEINFO,MB_OK);
		goto BackupRingsEnd;
	}
	// Go into a loop and copy the file.
	//..................................
	while(TRUE)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto BackupRingsEnd;
		}
		bResult = ReadMyFile((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,lpBuffer,
							  SIZE_BACKUP_BUFFER,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto BackupRingsEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,lpBuffer,dwBytesRead,
							   &dwBytesWritten,NULL);
		if (!bResult)
		{
			goto BackupRingsEnd;
		}
		// Update the status bar to reflect this file.
		//............................................
		liStats.QuadPart += dwBytesRead;
		while(liStats.QuadPart >= liHalfPercentDup.QuadPart)
		{
			SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);
			liStats.QuadPart -= liHalfPercentDup.QuadPart;
		}
	}
	bResult = SetFileTime(hOutPutFile,&fi.ftCreationTime,&fi.ftLastAccessTime,
						  &fi.ftLastWriteTime);
	if (!bResult)
	{
		ErrorProcedure((LPTSTR)&szDestination,IDS_SETFILETIME,MB_OK);
	}
	// Close the destination file.
	//............................
	bResult = CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
	if (!bResult)
	{
		goto BackupRingsEnd;
	}
	hOutPutFile = 0;
	bDiskError = FALSE;

	bResult = SetFileAttributes((LPCTSTR)&szDestination,fi.dwFileAttributes);
	if (!bResult)
	{
		ErrorProcedure((LPTSTR)&szDestination,IDS_SETFILEATTR,MB_OK);
	}
	// Update the files copied.
	//.........................
	iFilesCopied++;
	StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFilesCopied,
					iFilesCopied,iTotalFiles);
	SetDlgItemText(hDialogModeLess,IDC_STATEMENT1,(LPCTSTR)&szOutBuffer);

  SecretKeyRing:

	// Do the secret key ring second.
	//...............................
	lpFileExtension = PathFindExtension((LPCTSTR)&cfg.szSecretKeyRing);
	lpFileName = PathFindFileName((LPCTSTR)&cfg.szSecretKeyRing);

	// Setup the destination spec. for the public key ring.
	//.....................................................
	*lpDestinationInsert = 0;
	StringCbCatEx(szDestination,sizeof(szDestination),lpFileName,NULL,NULL,
				  dwStringSafeFlag);

	// Destroy the icon if we used it.
	//................................
	if (hIcon)
	{
		DestroyIcon(hIcon);
		hIcon = 0;
	}
	// Let find the icon for the file.
	//................................
	hIcon = FindMyIcon((LPBYTE)&cfg.szSecretKeyRing,lpFileExtension);

	// If we did not find one, use the default.
	//.........................................
	if (!hIcon)
	{
		hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
	}
	// See if the file exists in the destination.
	//...........................................
	if (!bSkipTheRest)
	{
		hSearch = FindFirstFile((LPCTSTR)&szDestination,&wfd);
		
		if (hSearch != INVALID_HANDLE_VALUE)
		{
			FindClose(hSearch);

			FlashMyIcon(FALSE);

			CopyMemory(&szFileName,&cfg.szSecretKeyRing,MAX_PATH);

			// Ask if we want to overwrite the file.
			//......................................
			iResult = DialogBox(hInst,TEXT("ASKOVERWRITE"),hMainWindow,
							   (DLGPROC)AskOverwriteProc);

			EmptyTheMessageQue();

			// See if we had a system error in creating the dialog box.
			//.........................................................
			if (iResult == -1)
			{
				ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
				goto BackupRingsEnd;
			}
			// Quit if we canceled.
			//.....................
			if (iResult == IDCANCEL)
			{
				goto BackupRingsEnd;
			}
			// If we said no.
			//...............
			if (iResult == IDC_MYNO)
			{
				iNumberOfFiles--;
				goto BackupRingsEnd;
			}
		}
	}
	// Set bDiskError to TRUE.
	//........................
	bDiskError = TRUE;

	// Create the output file.
	//........................
	hOutPutFile =  CreateMyFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,
							     0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hOutPutFile)
	{
		goto BackupRingsEnd;
	}
	liStats.QuadPart = 0;

	// Display the icon and file name.
	//................................
	if (hIcon2)
	{
		DestroyIcon(hIcon2);
	}
	hIcon2 = hIcon;
	hIcon = 0;

	SendMessage(GetDlgItem(hDialogModeLess,IDC_ICON1),STM_SETICON,(WPARAM)hIcon2,0);
	SetDlgItemTextFmt(hDialogModeLess,IDC_BACKUPFILENAME,
					 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&cfg.szSecretKeyRing));

	// Get the attribs and file times to put on the copied files.
	//...........................................................
	bResult = GetFileInformationByHandle(hSecretKeyRing,&fi);
	if (!bResult)
	{
		ErrorProcedure((LPTSTR)&cfg.szSecretKeyRing,IDS_GETFILEINFO,MB_OK);
		goto BackupRingsEnd;
	}
	// Go into a loop and copy the file.
	//..................................
	while(TRUE)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto BackupRingsEnd;
		}
		bResult = ReadMyFile((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing,lpBuffer,
							  SIZE_BACKUP_BUFFER,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto BackupRingsEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,lpBuffer,dwBytesRead,
							   &dwBytesWritten,NULL);
		if (!bResult)
		{
			goto BackupRingsEnd;
		}
		// Update the status bar to reflect this file.
		//............................................
		liStats.QuadPart += dwBytesRead;
		while(liStats.QuadPart >= liHalfPercentDup.QuadPart)
		{
			SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);
			liStats.QuadPart -= liHalfPercentDup.QuadPart;
		}
	}
	bResult = SetFileTime(hOutPutFile,&fi.ftCreationTime,&fi.ftLastAccessTime,
						  &fi.ftLastWriteTime);
	if (!bResult)
	{
		ErrorProcedure((LPTSTR)&szDestination,IDS_SETFILETIME,MB_OK);
	}
	// Close the destination file.
	//............................
	bResult = CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
	if (!bResult)
	{
		goto BackupRingsEnd;
	}
	hOutPutFile = 0;
	bDiskError = FALSE;

	bResult = SetFileAttributes((LPCTSTR)&szDestination,fi.dwFileAttributes);
	if (!bResult)
	{
		ErrorProcedure((LPTSTR)&szDestination,IDS_SETFILEATTR,MB_OK);
	}
	// Update the files copied.
	//.........................
	iFilesCopied++;
	StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFilesCopied,
				    iFilesCopied,iTotalFiles);
	SetDlgItemText(hDialogModeLess,IDC_STATEMENT1,(LPCTSTR)&szOutBuffer);

  BackupRingsEnd:

	return(bDiskError);
}
